document.addEventListener('DOMContentLoaded', () => {
 
  const sidebar = document.getElementById('sidebar');
  const appContainer = document.getElementById('app-container');
  const toggleBtn = document.getElementById('sidebar-toggle');
  //const colorPicker = document.getElementById('sidebar-color-picker');
  const exitBtn = document.getElementById('exit-btn');

  if (!sidebar) console.error('No se encontró el elemento sidebar');
  if (!appContainer) console.error('No se encontró elemento appContainer');
  if (!toggleBtn) console.error('No se encontró elemento toggleBtn');
  //if (!colorPicker) console.error('No se encontró elemento colorPicker');
  if (!exitBtn) {
    console.error('No se encontró elemento exitBtn');
  } else {
    //console.log('Elemento exitBtn encontrado');

    // Evento salir con SweetAlert para confirmación
    exitBtn.addEventListener('click', () => {
      Swal.fire({
        title: '¿Desea salir de la aplicación?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, salir',
        cancelButtonText: 'Cancelar',
        reverseButtons: true,
      }).then((result) => {
        if (result.isConfirmed) {
          window.location.href = 'logout.php';
        }
      });
    });
  }

  // Estado inicial expandido
  let isExpanded = true;

  function updateToggleIcon() {
    const icon = toggleBtn.querySelector('.material-icons');
    icon.textContent = isExpanded ? 'chevron_left' : 'chevron_right';
    toggleBtn.setAttribute('aria-pressed', String(isExpanded));
  }

  function toggleSidebar() {
    isExpanded = !isExpanded;
    if (isExpanded) {
      sidebar.classList.remove('collapsed');
      sidebar.classList.add('expanded');
      appContainer.classList.remove('collapsed');
      appContainer.classList.add('expanded');
      toggleBtn.setAttribute('title', 'Contraer barra lateral');
    } else {
      sidebar.classList.remove('expanded');
      sidebar.classList.add('collapsed');
      appContainer.classList.remove('expanded');
      appContainer.classList.add('collapsed');
      toggleBtn.setAttribute('title', 'Expandir barra lateral');
    }
    updateToggleIcon();
  }

  toggleBtn.addEventListener('click', toggleSidebar);
  toggleBtn.addEventListener('keydown', (e) => {
    if (e.key === 'Enter' || e.key === ' ') {
      e.preventDefault();
      toggleSidebar();
    }
  });

  /*colorPicker.addEventListener('input', () => {
    const color = colorPicker.value;
    document.documentElement.style.setProperty('--sidebar-bg-color', color);
    document.documentElement.style.setProperty('--sidebar-hover-bg', hexToRgba(color, 0.75));
    document.documentElement.style.setProperty('--sidebar-border-color', hexToRgba(color, 0.85));
  });*/

  function hexToRgba(hex, alpha) {
    let r = 0, g = 0, b = 0;
    if (hex.length === 4) {
      r = "0x" + hex[1] + hex[1];
      g = "0x" + hex[2] + hex[2];

      
      b = "0x" + hex[3] + hex[3];
    } else if (hex.length === 7) {
      r = "0x" + hex[1] + hex[2];
      g = "0x" + hex[3] + hex[4];
      b = "0x" + hex[5] + hex[6];
    }
    return `rgba(${+r},${+g},${+b},${alpha})`;
  }

  // Menú hamburguesa para móvil
  function createHamburgerMenu() {
    const hamburgerBtn = document.createElement('button');
    hamburgerBtn.id = 'hamburger-menu';
    hamburgerBtn.type = 'button';
    hamburgerBtn.className = 'btn btn-outline-secondary d-md-none me-2';
    hamburgerBtn.setAttribute('aria-label', 'Mostrar u ocultar menú lateral');
    hamburgerBtn.innerHTML = '<span class="material-icons">menu</span>';
    const headerTitle = document.querySelector('#sidebar-header .sidebar-title');
    if (headerTitle && headerTitle.parentNode) {
      headerTitle.parentNode.insertBefore(hamburgerBtn, headerTitle);
      hamburgerBtn.addEventListener('click', () => {
        sidebar.classList.toggle('show');
      });
    }
  }
  createHamburgerMenu();
  updateToggleIcon();
});
