<?php include 'includes/auth_check.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Visualizar Archivos</title>
  <link rel="icon" href="assets/images/logo.png" type="image/png"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/datatables.net-dt/css/jquery.dataTables.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  
  <style>

    body, html {
      height: 100%;
      margin: 0;
    }
    .shred {
      animation: shred 10s forwards; 
    }
    @keyframes shred {
      0% {
        transform: translateY(0);
        opacity: 1;
      }
      50% {
        transform: translateY(-20px) rotate(5deg);
        opacity: 0.5;
      }
      100% {
        transform: translateY(100px) rotate(90deg);
        opacity: 0;
      }
    }
  </style>
</head>

<body>
<div id="app-container" class="expanded">
  <?php include 'includes/sidebar.php'; 

include 'includes/config.php';
$query = "SELECT * FROM archivos_pdf";
$result = $conn->query($query);
?>
<main id="main-content" tabindex="0">
  <h2>Visualizar Archivos</h2>
  <p></p>
  
  <table id="pdfTable" class="table table-striped">
    <thead>
      <tr>
        <th>n°</th>
        <th>Nombre PDF</th>
        <th>Clave Secreta</th>
        <th>Fecha Subida</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result->num_rows > 0): ?>
        <?php $counter = 1;  ?>
        <?php while ($archivo = $result->fetch_assoc()): 
          ?>
          <tr>
            <td><?= $counter++ ?></td> 
            <td><?= htmlspecialchars($archivo['nombre_pdf']) ?></td>
            <td><?= htmlspecialchars($archivo['clave_secreta']) ?></td>
            <td><?= htmlspecialchars($archivo['fecha_subida']) ?></td>
            <td>
              <button onclick="showPdf('<?= htmlspecialchars($archivo['url_pdf']) ?>')" class="btn btn-primary">
                <img src="assets/images/ver.png" alt="Ver" width="20">
              </button>
              <button onclick="deleteRecord(<?= $archivo['id'] ?>)" class="btn btn-danger">
                <img src="assets/images/borrar.png" alt="Eliminar" width="20">
              </button>
            </td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr>
          <td colspan="5">No hay registros disponibles.</td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>
</main>

<!-- Modal para ver PDF -->
<div class="modal fade" id="pdfModal" tabindex="-1" aria-labelledby="pdfModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="pdfModalLabel">Ver PDF</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <iframe id="pdfViewer" style="width: 100%; height: 500px;" frameborder="0"></iframe>
      </div>
    </div>
  </div>
</div>
</div>
    <footer id="page-footer" style="background-color: #1C2255; color: #f8f9fa; text-align: center; padding: 1rem 0; font-family: 'Poppins', sans-serif;">
        &copy; <?= date('Y') ?> OITE - DIRESA APURIMAC. Todos los derechos reservados.
    </footer>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="assets/js/sidebar.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/datatables.net/js/jquery.dataTables.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#pdfTable').DataTable();
    });
    function showPdf(url) {
      document.getElementById('pdfViewer').src = url;
      const modal = new bootstrap.Modal(document.getElementById('pdfModal'));
      modal.show();
    }

    function deleteRecord(id) {
      Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: 'delete.php',
            type: 'POST',
            data: { id: id },
            success: function(response) {
              const result = JSON.parse(response);
              if (result.success) {
                const row = $(`#row-${id}`);
                row.addClass('shred'); 
                setTimeout(() => {
                  row.remove(); 
                  Swal.fire(
                    'Eliminado!',
                    'El registro ha sido eliminado.',
                    'success'
                  );
                }, 1000); 
              } else {
                Swal.fire('Error', 'Error al eliminar el registro: ' + result.message, 'error');
              }
            },
            error: function() {
              Swal.fire('Error', 'Error en la solicitud. Inténtalo de nuevo.', 'error');
            }
          });
        }
      });
    }

  </script>
</body>
</html>
