<?php include 'includes/auth_check.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Generador QR</title>
  <link rel="icon" href="assets/images/logo.png" type="image/png"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="assets/css/qr.css" />
  <style>
    body, html {
      height: 100%;
      margin: 0;
      font-family: 'Poppins', sans-serif;
    }
    @media (max-width: 576px) {
      .upload-buttons {
        flex-direction: column;
      }
      .upload-buttons button {
        width: 100%;
        justify-content: center;
      }
      .buttons-container {
        flex-direction: column;
      }
      .button-card {
        width: 100%;
      }
    }
  </style>
</head>
<body>
  <div id="app-container" class="expanded">
    <?php include 'includes/sidebar.php'; ?>
    <main id="main-content" tabindex="0">
      <div class="container">
        <form id="uploadForm" action="process_pdf.php" method="POST" enctype="multipart/form-data">
          <div class="upload-card">
            <h2 class="text-center mb-4">Subir Archivo PDF</h2>
            <div class="upload-area" id="uploadfile" style="cursor:pointer;">
              <h4>Arrastra y suelta tu archivo aquí</h4>
              <p>O haz clic para seleccionar un archivo</p>
              <input type="file" name="pdfFile" id="pdfFile" accept="application/pdf" required style="display:none;" />
            </div>
            <div class="upload-buttons mt-3 d-flex justify-content-center gap-3 flex-wrap">
              <button type="submit" id="btnGuardar" class="btn btn-primary d-flex align-items-center gap-2">
                Guardar
                <img src="assets/images/guardar.png" alt="Guardar" style="width:20px; height:20px;" />
              </button>
              <button type="button" id="btnLimpiar" class="btn btn-secondary d-flex align-items-center gap-2">
                Limpiar
                <img src="assets/images/limpiar.png" alt="Limpiar" style="width:20px; height:20px;" />
              </button>
            </div>
          </div>
        </form>
      </div>
    </main>
  </div>

  <footer id="page-footer" style="background-color: #1C2255; color: #f8f9fa; text-align: center; padding: 1rem 0; font-family: 'Poppins', sans-serif;">
      &copy; <?= date('Y') ?> OITE - DIRESA APURIMAC. Todos los derechos reservados.
  </footer>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    const uploadArea = document.getElementById('uploadfile');
    const fileInput = document.getElementById('pdfFile');
    const btnLimpiar = document.getElementById('btnLimpiar');

    uploadArea.addEventListener('click', () => fileInput.click());

    fileInput.addEventListener('change', () => {
      const fileName = fileInput.files[0] ? fileInput.files[0].name : 'Ningún archivo seleccionado';
      uploadArea.querySelector('h4').textContent = fileName;
      uploadArea.querySelector('p').textContent = '';
    });

    btnLimpiar.addEventListener('click', () => {
      fileInput.value = '';
      uploadArea.querySelector('h4').textContent = 'Arrastra y suelta tu archivo aquí';
      uploadArea.querySelector('p').textContent = 'O haz clic para seleccionar un archivo';
    });

    const uploadForm = document.getElementById('uploadForm');

    uploadForm.addEventListener('submit', (event) => {
      event.preventDefault(); 

      const formData = new FormData(uploadForm);
      fetch('process_pdf.php', {
        method: 'POST',
        body: formData
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          Swal.fire({
            title: 'Documento procesado correctamente',
            text: '¿Qué deseas hacer?',
            icon: 'success',
            showCancelButton: true,
            confirmButtonText: 'Descargar PDF',
            cancelButtonText: 'Visualizar PDF'
          }).then((result) => {
            if (result.isConfirmed) {
              window.location.href = data.url; 
            } else if (result.isDismissed) {
              const modal = document.createElement('div');
              modal.innerHTML = `<iframe src="${data.url}" style="width:100%; height:500px;" frameborder="0"></iframe>`;
              document.body.appendChild(modal);
              Swal.fire({
                title: 'Visualizando PDF',
                html: modal,
                showCloseButton: true,
                focusConfirm: false,
                confirmButtonText: 'Cerrar'
              });
            }
          });
        } else {
          Swal.fire('Error', data.message || 'No se pudo procesar el documento.', 'error');
        }
      })
      .catch(error => {
        console.error('Error:', error);
        Swal.fire('Error', 'Ocurrió un error al procesar el documento.', 'error');
      });
    });
  </script>
</body>
</html>
