<?php
$uploadDir = __DIR__ . '/uploads/';

if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$fileUrl = '';
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['pdfFile']) && $_FILES['pdfFile']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['pdfFile']['tmp_name'];
        $fileName = $_FILES['pdfFile']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        if ($fileExtension === 'pdf') {
            $newFileName = uniqid('pdf_', true) . '.' . $fileExtension;
            $destPath = $uploadDir . $newFileName;
            
            if (move_uploaded_file($fileTmpPath, $destPath)) {
                $fileUrl = 'uploads/' . $newFileName;
                $message = "Archivo subido correctamente: $fileName";
            } else {
                $message = "Error al mover el archivo.";
            }
        } else {
            $message = "Solo se permiten archivos PDF.";
        }
    } else {
        $message = "Error en la subida del archivo.";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Subir y visualizar PDF</title>
  <style>
    body { font-family: Arial, sans-serif; padding: 20px; background: #f0f0f0; }
    .container { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 8px; }
    .message { margin-bottom: 1em; color: green; }
    iframe { width: 100%; height: 600px; border: 1px solid #ccc; border-radius: 8px; }
    label { font-weight: bold; }
    input[type=file] { margin-top: 10px; }
    button { margin-top: 10px; padding: 8px 16px; font-weight: bold; background-color: #1C2255; color: white; border: none; border-radius: 4px; cursor: pointer; }
    button:hover { background-color: #414a99; }
  </style>
</head>
<body>
  <div class="container">
    <h1>Subir y visualizar PDF</h1>
    <?php if ($message): ?>
      <p class="message"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>
    <form method="post" enctype="multipart/form-data">
      <label for="pdfFile">Seleccione un archivo PDF:</label><br />
      <input type="file" name="pdfFile" id="pdfFile" accept="application/pdf" required /><br />
      <button type="submit">Subir PDF</button>
    </form>

    <?php if ($fileUrl): ?>
      <h2>PDF subido:</h2>
      <iframe src="<?= htmlspecialchars($fileUrl) ?>"></iframe>
      <p>Verifica el PDF para decidir la posición del código QR y el texto a extraer.</p>
    <?php endif; ?>
  </div>
</body>
</html>
