<?php include 'includes/auth_check.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Administrar Usuarios</title>
  <link rel="icon" href="assets/images/logo.png" type="image/png"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" />

  <style>
    body, html {
      height: 100%;
      margin: 0;
    }
  </style>
</head>
<body>
<div id="app-container" class="expanded">
  <?php include 'includes/sidebar.php'; 
  include 'includes/config.php';
  $query = "SELECT * FROM usuarios";
  $result = $conn->query($query);
  ?>

  <main id="main-content" tabindex="0">
    <h2>Administrar Usuarios</h2>
    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addUserModal">Agregar Usuario</button>
    
    <table id="userTable" class="table table-striped">
      <thead>
        <tr>
          <th>n°</th>
          <th>Nombre</th>
          <th>Usuario</th>
          <th>Fecha Registro</th>
          <th>Correo</th>
          <th>Celular</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result->num_rows > 0): ?>
          <?php $counter = 1; ?>
          <?php while ($usuario = $result->fetch_assoc()): ?>
            <tr id="row-<?= $usuario['id'] ?>">
              <td><?= $counter++ ?></td>
              <td><?= htmlspecialchars($usuario['nombre']) ?></td>
              <td><?= htmlspecialchars($usuario['usuario']) ?></td>
              <td><?= htmlspecialchars($usuario['fecha_registro']) ?></td>
              <td><?= htmlspecialchars($usuario['correo']) ?></td>
              <td><?= htmlspecialchars($usuario['celular']) ?></td>
              <td>
                <button onclick="editUser (<?= $usuario['id'] ?>)" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editUserModal">
                  Editar
                </button>
                <button onclick="deleteUser (<?= $usuario['id'] ?>)" class="btn btn-danger">
                  Eliminar
                </button>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr>
            <td colspan="7">No hay registros disponibles.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </main>

  <!-- Modal para Agregar Usuario -->
  <div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUser ModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addUser ModalLabel">Agregar Usuario</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form id="addUserForm">
            <div class="mb-3">
              <label for="addNombre" class="form-label">Nombre</label>
              <input type="text" class="form-control" id="addNombre" required>
            </div>
            <div class="mb-3">
              <label for="addUsuario" class="form-label">Usuario</label>
              <input type="text" class="form-control" id="addUsuario" required>
            </div>
            <div class="mb-3">
              <label for="addPassword" class="form-label">Contraseña</label>
              <input type="password" class="form-control" id="addPassword" required>
            </div>
            <div class="mb-3">
              <label for="addCorreo" class="form-label">Correo</label>
              <input type="email" class="form-control" id="addCorreo" required>
            </div>
            <div class="mb-3">
              <label for="addCelular" class="form-label">Celular</label>
              <input type="text" class="form-control" id="addCelular" required>
            </div>
            <button type="submit" class="btn btn-primary">Agregar Usuario</button>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal para Editar Usuario -->
  <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUser ModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editUser ModalLabel">Editar Usuario</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form id="editUserForm">
            <input type="hidden" id="editUserId">
            <div class="mb-3">
              <label for="editNombre" class="form-label">Nombre</label>
              <input type="text" class="form-control" id="editNombre" required>
            </div>
            <div class="mb-3">
              <label for="editUsuario" class="form-label">Usuario</label>
              <input type="text" class="form-control" id="editUsuario" required>
            </div>
            <div class="mb-3">
              <label for="editPassword" class="form-label">Contraseña (dejar en blanco si no desea cambiar)</label>
              <input type="password" class="form-control" id="editPassword">
            </div>
            <div class="mb-3">
              <label for="editCorreo" class="form-label">Correo</label>
              <input type="email" class="form-control" id="editCorreo" required>
            </div>
            <div class="mb-3">
              <label for="editCelular" class="form-label">Celular</label>
              <input type="text" class="form-control" id="editCelular" required>
            </div>
            <button type="submit" class="btn btn-primary">Guardar Cambios</button>
          </form>
        </div>
      </div>
    </div>
  </div>

</div>

<footer id="page-footer" style="background-color: #1C2255; color: #f8f9fa; text-align: center; padding: 1rem 0; font-family: 'Poppins', sans-serif;">
    &copy; <?= date('Y') ?> OITE - DIRESA APURIMAC. Todos los derechos reservados.
</footer>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="assets/js/sidebar.js"></script>

<script>
  $(document).ready(function() {
    $('#userTable').DataTable(); // Inicializa DataTables

    // Manejar el envío del formulario para agregar usuario
    $('#addUserForm').on('submit', function(e) {
      e.preventDefault();
      const nombre = $('#addNombre').val().toUpperCase(); // Convertir a mayúsculas
      const usuario = $('#addUsuario').val();
      const password = $('#addPassword').val();
      const correo = $('#addCorreo').val();
      const celular = $('#addCelular').val();

      Swal.fire({
        title: '¿Estás seguro?',
        text: "¿Deseas agregar este usuario?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, agregar!'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: 'add_user.php', // Archivo PHP para agregar usuario
            type: 'POST',
            data: {
              nombre: nombre,
              usuario: usuario,
              password: password,
              correo: correo,
              celular: celular
            },
            success: function(response) {
              const result = JSON.parse(response);
              if (result.success) {
                $('#addUserModal').modal('hide');
                location.reload(); // Recargar la página para ver el nuevo usuario
              } else {
                alert('Error al agregar usuario: ' + result.message);
              }
            },
            error: function() {
              alert('Error en la solicitud. Inténtalo de nuevo.');
            }
          });
        }
      });
    });

    // Manejar el envío del formulario para editar usuario
    $('#editUserForm').on('submit', function(e) {
      e.preventDefault();
      const id = $('#editUserId').val();
      const nombre = $('#editNombre').val().toUpperCase(); // Convertir a mayúsculas
      const usuario = $('#editUsuario').val();
      const password = $('#editPassword').val(); // Puede estar vacío
      const correo = $('#editCorreo').val();
      const celular = $('#editCelular').val();

      Swal.fire({
        title: '¿Estás seguro?',
        text: "¿Deseas guardar los cambios?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, guardar cambios!'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: 'edit_user.php', // Archivo PHP para editar usuario
            type: 'POST',
            data: {
              id: id,
              nombre: nombre,
              usuario: usuario,
              password: password,
              correo: correo,
              celular: celular
            },
            success: function(response) {
              const result = JSON.parse(response);
              if (result.success) {
                $('#editUserModal').modal('hide');
                location.reload(); // Recargar la página para ver los cambios
              } else {
                alert('Error al editar usuario: ' + result.message);
              }
            },
            error: function() {
              alert('Error en la solicitud. Inténtalo de nuevo.');
            }
          });
        }
      });
    });
  });

  // Función para llenar el modal de edición
  function editUser (id) {
    $.ajax({
      url: 'get_user.php', // Archivo PHP para obtener los datos del usuario
      type: 'GET',
      data: { id: id },
      success: function(response) {
        const usuario = JSON.parse(response);
        $('#editUserId').val(usuario.id);
        $('#editNombre').val(usuario.nombre);
        $('#editUsuario').val(usuario.usuario);
        $('#editCorreo').val(usuario.correo);
        $('#editCelular').val(usuario.celular);
      },
      error: function() {
        alert('Error al obtener los datos del usuario.');
      }
    });
  }

  // Función para eliminar usuario
  function deleteUser (id) {
    if (confirm('¿Estás seguro de que deseas eliminar este usuario?')) {
      $.ajax({
        url: 'delete_user.php', // Archivo PHP para eliminar usuario
        type: 'POST',
        data: { id: id },
        success: function(response) {
          const result = JSON.parse(response);
          if (result.success) {
            $(`#row-${id}`).remove(); // Eliminar la fila de la tabla
            alert('Usuario eliminado exitosamente.');
          } else {
            alert('Error al eliminar usuario: ' + result.message);
          }
        },
        error: function() {
          alert('Error en la solicitud. Inténtalo de nuevo.');
        }
      });
    }
  }
</script>
</body>
</html>
